/*
 * Decompiled with CFR 0.152.
 */
package engine;

import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class ImageLib {
    private Hashtable<String, BufferedImage[]> byName = new Hashtable();
    public BufferedImage[] player;
    public BufferedImage background = this.loadPics("pics/background.jpg", 1)[0];
    public BufferedImage[] fail;
    public BufferedImage particleRed = this.loadPics("pics/particle_red.png", 1)[0];

    public ImageLib() {
        this.player = this.loadPics("pics/player.png", 18);
        this.byName.put("player", this.player);
        BufferedImage[] data = null;
        data = this.loadPics("pics/on.png", 1);
        this.byName.put("on", data);
        data = this.loadPics("pics/off.png", 1);
        this.byName.put("off", data);
        data = this.loadPics("pics/playerdead.png", 1);
        this.byName.put("playerdead", data);
        data = this.loadPics("pics/spikes1.png", 2);
        this.byName.put("spikes1", data);
        data = this.loadPics("pics/spikes2.png", 2);
        this.byName.put("spikes2", data);
        data = this.loadPics("pics/spikes1d.png", 2);
        this.byName.put("spikes1d", data);
        data = this.loadPics("pics/spikes2d.png", 2);
        this.byName.put("spikes2d", data);
        data = this.loadPics("pics/spikes2l.png", 2);
        this.byName.put("spikes2l", data);
        data = this.loadPics("pics/spikes2r.png", 2);
        this.byName.put("spikes2r", data);
        data = this.loadPics("pics/wall.jpg", 1);
        this.byName.put("wall", data);
        data = this.loadPics("pics/sandstone.gif", 10);
        this.byName.put("sandstone", data);
        this.fail = this.loadPics("pics/fail.gif", 1);
        this.byName.put("fail", this.fail);
        data = this.loadPics("pics/shredder.png", 9);
        this.byName.put("shredder", data);
        data = this.loadPics("pics/hpball.png", 6);
        this.byName.put("hpball", data);
        data = this.loadPics("pics/hpgend.png", 1);
        this.byName.put("hpgend", data);
        data = this.loadPics("pics/hpgenl.png", 1);
        this.byName.put("hpgenl", data);
        data = this.loadPics("pics/hpgenr.png", 1);
        this.byName.put("hpgenr", data);
        data = this.loadPics("pics/hpgenu.png", 1);
        this.byName.put("hpgenu", data);
        data = this.loadPics("pics/key.png", 1);
        this.byName.put("key", data);
        data = this.loadPics("pics/rustybar.png", 1);
        this.byName.put("rustybar", data);
        data = this.loadPics("pics/rustybarh.png", 1);
        this.byName.put("rustybarh", data);
        data = this.loadPics("pics/arrowsu.png", 1);
        this.byName.put("arrowsu", data);
        data = this.loadPics("pics/arrowsr.png", 1);
        this.byName.put("arrowsr", data);
        data = this.loadPics("pics/arrowsl.png", 1);
        this.byName.put("arrowsl", data);
        data = this.loadPics("pics/cage.png", 1);
        this.byName.put("cage", data);
        data = this.loadPics("pics/cagenb.png", 1);
        this.byName.put("cagenb", data);
        data = this.loadPics("pics/mushroom.png", 1);
        this.byName.put("mushroom", data);
        data = this.loadPics("pics/cursor.png", 1);
        this.byName.put("cursor", data);
        data = this.loadPics("pics/youare.png", 1);
        this.byName.put("youare", data);
        data = this.loadPics("pics/dead.png", 1);
        this.byName.put("dead", data);
        data = this.loadPics("pics/stage.png", 1);
        this.byName.put("stage", data);
        data = this.loadPics("pics/wanna.png", 1);
        this.byName.put("wanna", data);
    }

    public BufferedImage[] getImagesByName(String name) {
        if (this.byName.containsKey(name)) {
            return this.byName.get(name);
        }
        return this.fail;
    }

    public BufferedImage[] tileImages(BufferedImage[] tile, int w, int h) {
        BufferedImage[] img = new BufferedImage[tile.length];
        for (int l = 0; l < tile.length; ++l) {
            Rectangle2D.Double anchor = new Rectangle2D.Double(0.0, 0.0, tile[l].getWidth(), tile[l].getHeight());
            TexturePaint tex = new TexturePaint(tile[l], anchor);
            img[l] = new BufferedImage(w, h, 2);
            Graphics2D g = img[l].createGraphics();
            g.setPaint(tex);
            g.fillRect(0, 0, w, h);
        }
        return img;
    }

    private BufferedImage[] loadPics(String path, int pics) {
        BufferedImage[] anim = new BufferedImage[pics];
        BufferedImage source = null;
        File pic = new File(path);
        try {
            source = ImageIO.read(pic);
        }
        catch (IOException e) {
            System.out.println(e.getLocalizedMessage());
        }
        for (int x = 0; x < pics; ++x) {
            anim[x] = source.getSubimage(x * source.getWidth() / pics, 0, source.getWidth() / pics, source.getHeight());
        }
        return anim;
    }
}

