/*
 * Decompiled with CFR 0.152.
 */
package engine;

public class Vector2D {
    public double x;
    public double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void add(Vector2D v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void capValues(double mx, double my) {
        if (Math.abs(this.x) > mx) {
            this.x = Math.signum(this.x) * mx;
        }
        if (Math.abs(this.y) > my) {
            this.y = Math.signum(this.y) * my;
        }
    }

    public void scale(double d) {
        this.x *= d;
        this.y *= d;
    }

    public void scaleTo(double l) {
        this.normalize();
        this.scale(l);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void normalize() {
        double l = this.length();
        this.x /= l;
        this.y /= l;
    }

    public Vector2D vecSub(Vector2D v) {
        return new Vector2D(this.x - v.x, this.y - v.y);
    }

    public Vector2D vecRotate(double deg) {
        double rad = deg * Math.PI / 180.0;
        return new Vector2D(this.x * Math.cos(rad) - this.y * Math.sin(rad), this.x * Math.sin(rad) + this.y * Math.cos(rad));
    }

    public Vector2D vecAdd(Vector2D v) {
        return new Vector2D(this.x + v.x, this.y + v.y);
    }

    public Vector2D projectX() {
        return new Vector2D(this.x, 0.0);
    }

    public Vector2D projectY() {
        return new Vector2D(0.0, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

