/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Vector2D;
import gameobjects.Particle;
import gameobjects.ParticleEffect;
import view.GamePanel;

public class BloodStain
extends ParticleEffect {
    private double duration;
    private GamePanel p;
    private Vector2D direction;

    public BloodStain(int maxParticles, Vector2D origin, Vector2D direction, GamePanel p) {
        super(maxParticles, origin);
        this.direction = direction;
        this.direction.scaleTo(30.0 + 30.0 * Math.random());
        this.p = p;
        this.duration = 300 + maxParticles;
    }

    public void doLogic(long delta) {
        double dt = delta / 1000000L;
        this.duration -= dt;
        if (this.duration < 0.0) {
            this.remove = true;
        } else if (this.particles.size() < this.maxParticles) {
            this.particles.add(new Particle(this.p.imgLib.particleRed, 500.0, this.origin.x, this.origin.y, this.direction.x, this.direction.y, true));
        }
        super.doLogic(delta);
    }
}

