/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Drawable;
import engine.Vector2D;
import gameobjects.Movable;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class Particle
implements Drawable,
Movable {
    private BufferedImage pic;
    public double x;
    public double y;
    public boolean remove = false;
    protected Vector2D dv;
    private boolean randomized = false;
    double animation = 0.0;
    double lifetime;

    public Particle(BufferedImage pic, double lifetime, double x, double y, double dx, double dy, boolean randomized) {
        this.x = x;
        this.y = y;
        this.pic = pic;
        this.lifetime = lifetime;
        this.randomized = randomized;
        this.dv = new Vector2D(dx, dy);
    }

    public void doLogic(long delta) {
        double dt = delta / 1000000L;
        this.lifetime -= dt;
        if (this.lifetime < 0.0) {
            this.remove = true;
        }
        if (!this.randomized) {
            return;
        }
        this.animation += dt;
        if (this.animation > 50.0) {
            this.animation = 0.0;
            this.dv.x += Math.random() * 20.0 - Math.random() * 20.0;
            this.dv.y += Math.random() * 20.0 - Math.random() * 20.0;
        }
    }

    public void move(long delta) {
        if (this.dv.x != 0.0) {
            this.x += this.dv.x * ((double)delta / 1.0E9);
        }
        if (this.dv.y != 0.0) {
            this.y += this.dv.y * ((double)delta / 1.0E9);
        }
    }

    public void drawObjects(Graphics g) {
        g.drawImage(this.pic, (int)this.x, (int)this.y, null);
    }
}

