/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Drawable;
import engine.Path;
import engine.Vector2D;
import gameobjects.AirDrag;
import gameobjects.Gravity;
import gameobjects.Movable;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import view.GamePanel;

public abstract class Sprite
extends Rectangle2D.Double
implements Comparable,
Drawable,
Movable,
Gravity,
AirDrag {
    protected static final double epsilon = 1.0E-10;
    protected long delay;
    protected long animation = 0L;
    protected int drawAt = 0;
    GamePanel parent;
    BufferedImage[] pics;
    protected int currentpic = 0;
    protected Vector2D dv;
    protected Vector2D dvMin;
    protected int loop_from;
    protected int loop_to;
    protected boolean loop_back = false;
    protected boolean loop_dir = true;
    protected int weight = 0;
    protected double oldX;
    protected double oldY;
    protected Vector2D center;
    public boolean remove = false;
    public short forcedX = 0;
    public short forcedY = 0;
    protected Path path = null;
    protected boolean pathUp = true;
    protected boolean repeat = true;
    protected int pathInd = 1;
    protected double speed = 50.0;

    public Sprite(BufferedImage[] i, double x, double y, long delay, GamePanel p) {
        this.pics = i;
        this.x = x;
        this.y = y;
        this.oldX = x;
        this.oldY = y;
        this.delay = delay;
        this.width = this.pics[0].getWidth();
        this.height = this.pics[0].getHeight();
        this.center = new Vector2D(x + this.width / 2.0, y + this.height / 2.0);
        this.parent = p;
        this.loop_from = 0;
        this.loop_to = this.pics.length - 1;
        this.dv = new Vector2D(0.0, 0.0);
        this.dvMin = new Vector2D(0.0, 0.0);
    }

    public void setPath(Path p, double speed, boolean repeat) {
        this.path = p;
        this.speed = speed;
        this.repeat = repeat;
    }

    public void drawObjects(Graphics g) {
        g.drawImage(this.pics[this.currentpic], (int)this.x, (int)this.y, null);
    }

    public void doLogic(long delta) {
        this.forcedY = 0;
        this.forcedX = 0;
        this.animation += delta / 1000000L;
        if (this.animation > this.delay) {
            this.animation = 0L;
            this.computeAnimation();
        }
        if (this.path != null) {
            this.dv = this.path.get(this.pathInd).vecSub(new Vector2D(this.x, this.y));
            if (this.dv.length() < 2.0) {
                if (!this.repeat && this.pathInd == this.path.size() - 1) {
                    this.path = null;
                    this.dv.scale(0.0);
                    return;
                }
                if (this.pathInd == this.path.size() - 1 || this.pathInd == 0) {
                    boolean bl = this.pathUp = !this.pathUp;
                }
                this.pathInd = this.pathUp ? ++this.pathInd : --this.pathInd;
            }
            this.dv.scaleTo(this.speed);
        }
    }

    public void forceMove(long delta, Vector2D v) {
        if (v.x != 0.0) {
            this.oldX = this.x;
            this.x += v.x * ((double)delta / 1.0E9);
            this.center.x = this.x + this.width / 2.0;
            if (v.x < 0.0) {
                if (this.forcedX > 0) {
                    this.crush();
                } else {
                    this.forcedX = (short)-1;
                }
            }
            if (v.x > 0.0) {
                if (this.forcedX < 0) {
                    this.crush();
                } else {
                    this.forcedX = 1;
                }
            }
        }
        if (v.y != 0.0) {
            this.oldY = this.y;
            this.y += v.y * ((double)delta / 1.0E9);
            this.center.y = this.y + this.height / 2.0;
            if (v.y < 0.0) {
                if (this.forcedY > 0) {
                    this.crush();
                } else {
                    this.forcedY = (short)-1;
                }
            }
            if (v.y > 0.0) {
                if (this.forcedY < 0) {
                    this.crush();
                } else {
                    this.forcedY = 1;
                }
            }
        }
    }

    protected void crush() {
    }

    public void move(long delta) {
        if (this.dv.x != 0.0) {
            this.oldX = this.x;
            this.x += this.dv.x * ((double)delta / 1.0E9);
            this.center.x = this.x + this.width / 2.0;
        }
        if (this.dv.y != 0.0) {
            this.oldY = this.y;
            this.y += this.dv.y * ((double)delta / 1.0E9);
            this.center.y = this.y + this.height / 2.0;
        }
    }

    protected void computeAnimation() {
        if (this.loop_dir) {
            ++this.currentpic;
        } else {
            --this.currentpic;
            if (this.currentpic < 0) {
                this.loop_dir = true;
                this.currentpic = 0;
            }
        }
        if (this.currentpic > this.loop_to) {
            if (this.loop_back) {
                this.loop_dir = false;
                --this.currentpic;
            } else {
                this.currentpic = this.loop_from;
            }
        }
    }

    public abstract boolean collidedWith(Sprite var1);

    public void setLoop(int from, int to) {
        this.loop_from = from;
        this.loop_to = to;
        this.currentpic = from;
    }

    public void setSpeed(Vector2D v) {
        this.dv = v;
    }

    public Vector2D getSpeed() {
        return this.dv;
    }

    public Vector2D getPos() {
        return new Vector2D(this.x, this.y);
    }

    public void addVerticalSpeed(double d) {
        this.dv.y += d;
    }

    public void addHorizontalSpeed(double d) {
        this.dv.x += d;
    }

    public void setVerticalSpeed(double d) {
        this.dv.y = d;
    }

    public void setHorizontalSpeed(double d) {
        this.dv.x = d;
    }

    public double getVerticalSpeed() {
        return this.dv.y;
    }

    public double getHorizontalSpeed() {
        return this.dv.x;
    }

    public void setX(double i) {
        this.x = i;
    }

    public void setY(double i) {
        this.y = i;
    }

    public void doAirDrag() {
        this.dv.x *= 0.97;
        this.dv.y *= 0.97;
        if (Math.abs(this.dv.x) < 5.0) {
            this.dv.x = 0.0;
        }
        if (Math.abs(this.dv.y) < 5.0) {
            this.dv.y = 0.0;
        }
    }

    public void doGravity(Vector2D v) {
        if (this.weight > 0) {
            this.dv.x += v.x;
            this.dv.y += v.y;
        }
    }

    public boolean checkPixelRectangleCollisions(Rectangle2D.Double s) {
        Rectangle2D.Double cut = (Rectangle2D.Double)this.createIntersection(s);
        if (cut.width < 1.0 || cut.height < 1.0) {
            return false;
        }
        Rectangle2D.Double sub_me = this.getSubRec(this, cut);
        BufferedImage img_me = this.pics[this.currentpic].getSubimage((int)sub_me.x, (int)sub_me.y, (int)sub_me.width, (int)sub_me.height);
        for (int i = 0; i < img_me.getWidth(); ++i) {
            for (int n = 0; n < img_me.getHeight(); ++n) {
                int rgb = img_me.getRGB(i, n);
                if (!this.isOpaque(rgb)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkPixelPixelCollisions(Sprite s) {
        Rectangle2D.Double cut = (Rectangle2D.Double)this.createIntersection(s);
        if (cut.width < 1.0 || cut.height < 1.0) {
            return false;
        }
        Rectangle2D.Double sub_me = this.getSubRec(this, cut);
        Rectangle2D.Double sub_him = this.getSubRec(s, cut);
        BufferedImage img_me = this.pics[this.currentpic].getSubimage((int)sub_me.x, (int)sub_me.y, (int)sub_me.width, (int)sub_me.height);
        BufferedImage img_him = s.pics[s.currentpic].getSubimage((int)sub_him.x, (int)sub_him.y, (int)sub_him.width, (int)sub_him.height);
        for (int i = 0; i < img_me.getWidth(); ++i) {
            for (int n = 0; n < img_him.getHeight(); ++n) {
                int rgb1 = img_me.getRGB(i, n);
                int rgb2 = img_him.getRGB(i, n);
                if (!this.isOpaque(rgb1) || !this.isOpaque(rgb2)) continue;
                return true;
            }
        }
        return false;
    }

    protected Rectangle2D.Double getSubRec(Rectangle2D.Double source, Rectangle2D.Double part) {
        Rectangle2D.Double sub = new Rectangle2D.Double();
        sub.x = source.x > part.x ? 0.0 : part.x - source.x;
        sub.y = source.y > part.y ? 0.0 : part.y - source.y;
        sub.width = part.width;
        sub.height = part.height;
        return sub;
    }

    protected boolean isOpaque(int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        return alpha != 0;
    }

    public int compareTo(Object o) {
        try {
            Sprite s = (Sprite)o;
            if (this.drawAt < s.drawAt) {
                return -1;
            }
            if (this.drawAt > s.drawAt) {
                return 1;
            }
        }
        catch (ClassCastException e) {
            return 0;
        }
        return 0;
    }

    public Vector2D getCenter() {
        return this.center;
    }
}

