/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import engine.Vector2D;
import gameobjects.Player;
import gameobjects.Sprite;
import java.awt.image.BufferedImage;
import view.GamePanel;

public class Wall
extends Sprite {
    public Wall(BufferedImage[] i, double x, double y, long delay, GamePanel p) {
        super(i, x, y, delay, p);
        this.weight = 1000;
    }

    public boolean collidedWith(Sprite s) {
        if (s.weight == 0) {
            return false;
        }
        if (!s.intersects(this)) {
            return false;
        }
        boolean resetX = false;
        boolean resetY = false;
        double tmpX = s.x;
        s.x = s.oldX;
        resetX = !s.intersects(this);
        s.x = tmpX;
        double tmpY = s.y;
        s.y = s.oldY;
        resetY = !s.intersects(this);
        s.y = tmpY;
        if (resetX && resetY) {
            resetY = false;
        }
        boolean realReset = false;
        if (!resetX && !resetY) {
            resetY = true;
            resetX = true;
            realReset = true;
        }
        Vector2D force = new Vector2D(0.0, 0.0);
        if (resetY) {
            if (s.dv.y > 0.0) {
                if (s instanceof Player) {
                    ((Player)s).resetJump();
                }
                force.y = -(1.0E9 / (double)this.parent.delta) * (s.y - this.y + s.getHeight() + 1.0E-10);
            } else {
                force.y = 1.0E9 / (double)this.parent.delta * (this.y + this.getHeight() + 1.0E-10 - s.y);
            }
            if (realReset) {
                force.y = -s.dv.y;
            }
            s.setVerticalSpeed(0.0);
        }
        if (resetX) {
            force.x = s.dv.x > 0.0 ? -(1.0E9 / (double)this.parent.delta) * (s.x - this.x + s.getWidth() + 1.0E-10) : 1.0E9 / (double)this.parent.delta * (this.x + this.getWidth() + 1.0E-10 - s.x);
            if (realReset) {
                force.x = -s.dv.x;
            }
            s.setHorizontalSpeed(0.0);
        }
        if (resetX || resetY) {
            s.forceMove(this.parent.delta, force);
        }
        this.additionalCollisionAction(s);
        return false;
    }

    protected void additionalCollisionAction(Sprite s) {
    }

    public void doAirDrag() {
    }

    public void doGravity(Vector2D v) {
    }
}

