/*
 * Decompiled with CFR 0.152.
 */
package view;

import engine.ImageLib;
import engine.Level;
import engine.SoundLib;
import engine.Vector2D;
import gameobjects.BloodStain;
import gameobjects.ParticleEffect;
import gameobjects.Player;
import gameobjects.Sprite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import view.TitleScreen;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener,
ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    boolean game_running = true;
    boolean started = false;
    boolean once = false;
    public long delta = 0L;
    public long lastDelta = 0L;
    long last = 0L;
    long fps = 0L;
    long ms = 10L;
    public long gameover = 0L;
    public Player player;
    private ArrayList<Sprite> actors;
    public Hashtable<String, Sprite> actorIndex;
    private boolean music;
    private boolean sound;
    private boolean playedStomp = false;
    private ArrayList<ParticleEffect> effects;
    boolean[] keysDown = new boolean[3];
    boolean[] keysReleased = new boolean[3];
    private static final int UP = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    boolean run = true;
    int acceleration = 40;
    public Vector2D gravity = new Vector2D(0.0, 25.0);
    Timer timer;
    public SoundLib slib;
    public ImageLib imgLib;
    private TitleScreen title;
    private String currentLevel = null;
    public static final int[] keyCodesFixed = new int[]{37, 39, 38, 32, 27};
    public int[] keyCodes = new int[]{37, 39, 38, 32, 27};
    private boolean adShown = false;

    public static void main(String[] args) {
        GamePanel p = new GamePanel(800, 600);
    }

    public GamePanel(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
        this.setBackground(Color.BLACK);
        JFrame frame = new JFrame("I wanna be... DEAD");
        frame.setVisible(true);
        frame.setDefaultCloseOperation(0);
        frame.addKeyListener(this);
        frame.addWindowListener(this);
        frame.add(this);
        frame.pack();
        frame.setVisible(true);
        frame.setResizable(true);
        this.doInitializations();
    }

    public void setMusic(boolean on) {
        if (this.music) {
            this.slib.stopMusic();
        } else {
            this.slib.playMusic();
        }
        this.music = on;
    }

    public boolean getMusic() {
        return this.music;
    }

    public void setSound(boolean on) {
        this.sound = on;
    }

    public boolean getSound() {
        return this.sound;
    }

    public void sound(String name) {
        if (this.sound) {
            this.slib.playSound(name);
        }
    }

    public void startLevel(String filename) {
        this.last = System.nanoTime();
        this.gameover = 0L;
        this.playedStomp = false;
        this.effects = new ArrayList();
        Level level = new Level(this, this.imgLib);
        if (!level.load(filename + ".xml")) {
            return;
        }
        this.currentLevel = filename;
        this.actors = level.getActors();
        this.player = level.getPlayer();
        this.actors.add(this.player);
        this.actorIndex = level.getActorIndex();
        Arrays.fill(this.keysDown, false);
        Arrays.fill(this.keysReleased, true);
        this.timer = new Timer(1000, this);
        this.timer.start();
        this.setStarted(true);
    }

    private void nextLevel() {
        String next = this.title.nextLevel(this.currentLevel);
        if (next == null) {
            this.setStarted(false);
        } else {
            this.startLevel(next);
        }
    }

    private void doInitializations() {
        this.music = true;
        this.sound = true;
        this.slib = new SoundLib();
        this.imgLib = new ImageLib();
        this.title = new TitleScreen(this.imgLib, this);
        if (!this.once) {
            this.once = true;
            Thread t = new Thread(this);
            t.start();
        }
        this.slib.playMusic();
    }

    public void createPlayerBloodStain(int particles, Vector2D direction) {
        this.effects.add(new BloodStain(particles, this.player.getCenter(), direction, this));
    }

    public void createPlayerBloodSplat() {
        if (this.effects.size() > 50) {
            return;
        }
        this.createPlayerBloodStain(10, new Vector2D(-10.0, 20.0));
        this.createPlayerBloodStain(10, new Vector2D(0.0, 20.0));
        this.createPlayerBloodStain(10, new Vector2D(10.0, 20.0));
        this.createPlayerBloodStain(10, new Vector2D(-10.0, -20.0));
        this.createPlayerBloodStain(10, new Vector2D(0.0, -20.0));
        this.createPlayerBloodStain(10, new Vector2D(10.0, -20.0));
        this.createPlayerBloodStain(10, new Vector2D(-10.0, 0.0));
        this.createPlayerBloodStain(10, new Vector2D(10.0, 0.0));
        if (!this.player.isDead()) {
            this.sound("splat");
        }
    }

    public void addActor(Sprite s) {
        this.actors.add(s);
    }

    public void run() {
        while (this.game_running) {
            this.computeDelta();
            if (this.isStarted()) {
                if (this.gameover == 0L) {
                    this.checkKeys();
                }
                this.doPhysics();
                this.moveObjects();
                this.doLogic();
            }
            this.repaint();
            try {
                if (this.fps > 63L) {
                    ++this.ms;
                }
                if (this.fps < 60L && this.ms > 1L) {
                    --this.ms;
                }
                Thread.sleep(this.ms);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doPhysics() {
        for (Sprite obj : this.actors) {
            obj.doAirDrag();
            obj.doGravity(this.gravity);
        }
    }

    private void doLogic() {
        int i;
        ArrayList<Sprite> trash = new ArrayList<Sprite>();
        for (i = 0; i < this.actors.size(); ++i) {
            this.actors.get(i).doLogic(this.delta);
            Sprite check = this.actors.get(i);
            if (!check.remove) continue;
            trash.add(check);
        }
        for (i = 0; i < this.effects.size(); ++i) {
            this.effects.get(i).doLogic(this.delta);
            if (!this.effects.get((int)i).remove) continue;
            this.effects.remove(i);
            --i;
        }
        for (i = 0; i < this.actors.size(); ++i) {
            for (int j = 0; j < this.actors.size(); ++j) {
                Sprite s2;
                Sprite s1;
                if (i == j || !(s1 = this.actors.get(i)).intersects(s2 = this.actors.get(j))) continue;
                s1.collidedWith(s2);
            }
        }
        if (trash.size() > 0) {
            for (Sprite s : trash) {
                this.actors.remove(s);
            }
        }
        if (this.gameover > 0L && !this.playedStomp && System.currentTimeMillis() - this.gameover > 900L) {
            this.playedStomp = true;
            this.sound("stomp");
        }
    }

    public void setGameover() {
        if (this.gameover == 0L) {
            this.gameover = System.currentTimeMillis();
        }
    }

    private void stopGame() {
        this.timer.stop();
        this.setStarted(false);
    }

    private void moveObjects() {
        int i;
        for (i = 0; i < this.actors.size(); ++i) {
            this.actors.get(i).move(this.delta);
        }
        for (i = 0; i < this.effects.size(); ++i) {
            this.effects.get(i).move(this.delta);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.imgLib != null) {
            g.drawImage(this.imgLib.background, 0, 0, this);
        }
        if (this.isStarted()) {
            int i;
            if (this.actors != null) {
                for (i = 0; i < this.actors.size(); ++i) {
                    this.actors.get(i).drawObjects(g);
                }
            }
            if (this.effects != null) {
                for (i = 0; i < this.effects.size(); ++i) {
                    this.effects.get(i).drawObjects(g);
                }
            }
            if (this.gameover > 0L && System.currentTimeMillis() - this.gameover > 1000L) {
                g.drawImage(this.imgLib.getImagesByName("youare")[0], 80, 80, null);
                g.drawImage(this.imgLib.getImagesByName("dead")[0], 400, 50, null);
                g.drawImage(this.imgLib.getImagesByName("stage")[0], 60, 200, null);
            }
        } else if (this.title != null) {
            this.title.drawObjects(g);
        }
    }

    private void computeDelta() {
        this.lastDelta = this.delta;
        this.delta = System.nanoTime() - this.last;
        this.last = System.nanoTime();
        this.fps = 1000000000L / this.delta;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    private void checkKeys() {
        Vector2D acc = new Vector2D(0.0, 0.0);
        if (this.keysDown[0]) {
            acc.y = -this.acceleration;
            boolean bl = this.keysDown[0] = !this.keysReleased[0];
        }
        if (this.keysDown[2]) {
            acc.x = this.acceleration;
            boolean bl = this.keysDown[2] = !this.keysReleased[2];
        }
        if (this.keysDown[1]) {
            acc.x = -this.acceleration;
            boolean bl = this.keysDown[1] = !this.keysReleased[1];
        }
        if (!this.keysDown[1] && !this.keysDown[2]) {
            acc.x = -this.player.cv.x / 7.0;
        }
        this.player.accelerate(acc);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == this.keyCodes[2] && this.keysReleased[0]) {
            this.keysDown[0] = true;
            this.keysReleased[0] = false;
        }
        if (e.getKeyCode() == this.keyCodes[0]) {
            this.keysDown[1] = true;
            this.keysReleased[1] = false;
        }
        if (e.getKeyCode() == this.keyCodes[1]) {
            this.keysDown[2] = true;
            this.keysReleased[2] = false;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.isStarted()) {
            if (e.getKeyCode() == this.keyCodes[2]) {
                this.keysReleased[0] = true;
            }
            if (e.getKeyCode() == this.keyCodes[0]) {
                this.keysReleased[1] = true;
            }
            if (e.getKeyCode() == this.keyCodes[1]) {
                this.keysReleased[2] = true;
            }
            if (e.getKeyCode() == this.keyCodes[4]) {
                this.title.setLevelIndexByName(this.currentLevel);
                this.setStarted(false);
            }
            if (e.getKeyCode() == this.keyCodes[3]) {
                if (this.gameover > 0L) {
                    if (System.currentTimeMillis() - this.gameover > 1000L) {
                        this.stopGame();
                        this.nextLevel();
                    }
                } else {
                    this.stopGame();
                    this.startLevel(this.currentLevel);
                }
            }
        } else {
            if (this.title.definingKey >= 0) {
                this.keyCodes[this.title.definingKey] = e.getKeyCode();
                this.title.defineNextKey();
                return;
            }
            if (e.getKeyCode() == 38) {
                this.title.control(1);
            }
            if (e.getKeyCode() == 40) {
                this.title.control(3);
            }
            if (e.getKeyCode() == 37) {
                this.title.control(4);
            }
            if (e.getKeyCode() == 39) {
                this.title.control(2);
            }
            if (e.getKeyCode() == 10) {
                this.title.control(5);
            }
            if (e.getKeyCode() == 32) {
                this.title.control(5);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isStarted() || e.getSource().equals(this.timer)) {
            // empty if block
        }
    }

    public void exitGame() {
        if (this.adShown) {
            System.exit(0);
        } else {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exitGame();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

